<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.6                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2015                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2015
 *
 * Generated from xml/schema/CRM/Volunteer/Project.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
class CRM_Volunteer_DAO_Project extends CRM_Core_DAO
{
  /**
   * static instance to hold the table name
   *
   * @var string
   */
  static $_tableName = 'civicrm_volunteer_project';
  /**
   * static instance to hold the field values
   *
   * @var array
   */
  static $_fields = null;
  /**
   * static instance to hold the keys used in $_fields for each field.
   *
   * @var array
   */
  static $_fieldKeys = null;
  /**
   * static instance to hold the FK relationships
   *
   * @var string
   */
  static $_links = null;
  /**
   * static instance to hold the values that can
   * be imported
   *
   * @var array
   */
  static $_import = null;
  /**
   * static instance to hold the values that can
   * be exported
   *
   * @var array
   */
  static $_export = null;
  /**
   * static value to see if we should log any modifications to
   * this table in the civicrm_log table
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Project Id
   *
   * @var int unsigned
   */
  public $id;
  /**
   * The title of the Volunteer Project
   *
   * @var string
   */
  public $title;
  /**
   * Full description of the Volunteer Project. Text and HTML allowed. Displayed on sign-up screens.
   *
   * @var text
   */
  public $description;
  /**
   * Entity table for entity_id (initially civicrm_event)
   *
   * @var string
   */
  public $entity_table;
  /**
   * Implicit FK project entity (initially eventID).
   *
   * @var int unsigned
   */
  public $entity_id;
  /**
   * Is this need enabled?
   *
   * @var boolean
   */
  public $is_active;
  /**
   * FK to Location Block ID
   *
   * @var int unsigned
   */
  public $loc_block_id;
  /**
   * The campaign associated with this Volunteer Project.
   *
   * @var int unsigned
   */
  public $campaign_id;
  /**
   * class constructor
   *
   * @return civicrm_volunteer_project
   */
  function __construct()
  {
    $this->__table = 'civicrm_volunteer_project';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns()
  {
    if (!self::$_links) {
      self::$_links = static ::createReferenceColumns(__CLASS__);
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'loc_block_id', 'civicrm_loc_block', 'id');
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'campaign_id', 'civicrm_campaign', 'id');
    }
    return self::$_links;
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields()
  {
    if (!(self::$_fields)) {
      self::$_fields = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('CiviVolunteer Project ID', array('domain' => 'org.civicrm.volunteer')) ,
          'description' => 'Project Id',
          'required' => true,
        ) ,
        'title' => array(
          'name' => 'title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Title', array('domain' => 'org.civicrm.volunteer')) ,
          'description' => 'The title of the Volunteer Project',
          'required' => true,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'description' => array(
          'name' => 'description',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Description', array('domain' => 'org.civicrm.volunteer')) ,
          'description' => 'Full description of the Volunteer Project. Text and HTML allowed. Displayed on sign-up screens.',
          'required' => false,
          'rows' => 8,
          'cols' => 60,
          'html' => array(
            'type' => 'RichTextEditor',
          ) ,
        ) ,
        'entity_table' => array(
          'name' => 'entity_table',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Entity Table', array('domain' => 'org.civicrm.volunteer')) ,
          'description' => 'Entity table for entity_id (initially civicrm_event)',
          'required' => true,
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
        ) ,
        'entity_id' => array(
          'name' => 'entity_id',
          'type' => CRM_Utils_Type::T_INT,
          'description' => 'Implicit FK project entity (initially eventID).',
          'required' => true,
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Enabled', array('domain' => 'org.civicrm.volunteer')) ,
          'description' => 'Is this need enabled?',
          'required' => true,
          'default' => '1',
        ) ,
        'loc_block_id' => array(
          'name' => 'loc_block_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Location Block ID') ,
          'description' => 'FK to Location Block ID',
          'FKClassName' => 'CRM_Core_DAO_LocBlock',
        ) ,
        'campaign_id' => array(
          'name' => 'campaign_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Campaign', array('domain' => 'org.civicrm.volunteer')) ,
          'description' => 'The campaign associated with this Volunteer Project.',
          'required' => false,
          'FKClassName' => 'CRM_Campaign_DAO_Campaign',
        ) ,
      );
    }
    return self::$_fields;
  }
  /**
   * Returns an array containing, for each field, the arary key used for that
   * field in self::$_fields.
   *
   * @return array
   */
  static function &fieldKeys()
  {
    if (!(self::$_fieldKeys)) {
      self::$_fieldKeys = array(
        'id' => 'id',
        'title' => 'title',
        'description' => 'description',
        'entity_table' => 'entity_table',
        'entity_id' => 'entity_id',
        'is_active' => 'is_active',
        'loc_block_id' => 'loc_block_id',
        'campaign_id' => 'campaign_id',
      );
    }
    return self::$_fieldKeys;
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName()
  {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog()
  {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false)
  {
    if (!(self::$_import)) {
      self::$_import = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('import', $field)) {
          if ($prefix) {
            self::$_import['volunteer_project'] = & $fields[$name];
          } else {
            self::$_import[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_import;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false)
  {
    if (!(self::$_export)) {
      self::$_export = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('export', $field)) {
          if ($prefix) {
            self::$_export['volunteer_project'] = & $fields[$name];
          } else {
            self::$_export[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_export;
  }
}
