<?php

class CRM_CivirulesConditions_GroupContact_GroupId extends CRM_Civirules_Condition {

  private $conditionParams = array();

  /**
   * Method to set the Rule Condition data
   *
   * @param array $ruleCondition
   * @access public
   */
  public function setRuleConditionData($ruleCondition) {
    parent::setRuleConditionData($ruleCondition);
    $this->conditionParams = array();
    if (!empty($this->ruleCondition['condition_params'])) {
      $this->conditionParams = unserialize($this->ruleCondition['condition_params']);
    }
  }

  public function isConditionValid(CRM_Civirules_TriggerData_TriggerData $triggerData) {
    $groupContact = $triggerData->getEntityData('GroupContact');
    if ($groupContact['group_id'] == $this->conditionParams['group_id']) {
      return true;
    }
    return false;
  }

  /**
   * Returns a redirect url to extra data input from the user after adding a condition
   *
   * Return false if you do not need extra data input
   *
   * @param int $ruleConditionId
   * @return bool|string
   * @access public
   * @abstract
   */
  public function getExtraDataInputUrl($ruleConditionId) {
    return CRM_Utils_System::url('civicrm/civirule/form/condition/groupcontact/groupid/', 'rule_condition_id='.$ruleConditionId);
  }

  /**
   * Returns a user friendly text explaining the condition params
   * e.g. 'Older than 65'
   *
   * @return string
   * @access public
   */
  public function userFriendlyConditionParams() {
    if (!empty($this->conditionParams['group_id'])) {
      $group = civicrm_api3('Group', 'getvalue', array('return' => 'title', 'id' => $this->conditionParams['group_id']));
      return ts('Group is %1', array(1 => $group));
    }
    return '';
  }

  /**
   * Returns an array with required entity names
   *
   * @return array
   * @access public
   */
  public function requiredEntities() {
    return array('GroupContact');
  }

}