<?php
// Color definitions for Pixture Reloaded.
$info = array(
  // Fields
  'fields' => array(
    'base'     => t('Base'),
    'page'     => t('Page background'),
    'sitename' => t('Site name'),
    'slogan'   => t('Slogan'),
    'header'   => t('Header text'),
    'mmenu'    => t('Main Menu links'),
    'link'     => t('Links'),
    'top'      => t('Header top'),
    'bottom'   => t('Header bottom'),
    'ftop'     => t('Footer top'),
    'fbottom'  => t('Footer bottom'),
    'text'     => t('Text'),
    'blockh'   => t('Block title bg'),
    'blockht'  => t('Block title'),
    'blockbg'  => t('Block body'),
    'borders'  => t('Borders'),
    'sticky'   => t('Sticky teaser'),
  ),
  // Pre-defined color schemes.
  'schemes' => array(
    'default' => array(
      'title' => t('Girly Pink (default)'),
      'colors' => array(
        'base'     => '#eb52c1',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#b21f88',
        'top'      => '#b800a5',
        'bottom'   => '#ff6bff',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#eb5ac3',
        'blockht'  => '#fffffc',
        'blockbg'  => '#f9cbec',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'redcarpet' => array(
      'title' => t('Red Carpet'),
      'colors' => array(
        'base'     => '#de8291',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#c55964',
        'top'      => '#861509',
        'bottom'   => '#f8306a',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#df8796',
        'blockht'  => '#fffffc',
        'blockbg'  => '#f5d9de',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'orangesunset' => array(
      'title' => t('Orange Sunset'),
      'colors' => array(
        'base'     => '#f7b42b',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#8e6130',
        'top'      => '#ec8c04',
        'bottom'   => '#fade42',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#f7b836',
        'blockht'  => '#fffffc',
        'blockbg'  => '#fde9c0',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'goldyellow' => array(
      'title' => t('Gold Yellow'),
      'colors' => array(
        'base'     => '#d1bc00',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#6c7019',
        'top'      => '#d5be01',
        'bottom'   => '#f0fd58',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#d3bf0d',
        'blockht'  => '#fffffc',
        'blockbg'  => '#f1ebb3',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'sandstone' => array(
      'title' => t('Sandstone'),
      'colors' => array(
        'base'     => '#d1681d',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#8b4513',
        'top'      => '#d37029',
        'bottom'   => '#d2691e',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#000000',
        'blockh'   => '#d37029',
        'blockht'  => '#fffffc',
        'blockbg'  => '#f1d2bc',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'caramelbrown' => array(
      'title' => t('Caramel Brown'),
      'colors' => array(
        'base'     => '#d59648',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#865518',
        'top'      => '#572e05',
        'bottom'   => '#eb8919',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#d79b51',
        'blockht'  => '#fffffc',
        'blockbg'  => '#f2e0c8',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'earthbrown' => array(
      'title' => t('Earth Brown'),
      'colors' => array(
        'base'     => '#cfb377',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#90712c',
        'top'      => '#463406',
        'bottom'   => '#e6bd5c',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#d1b77e',
        'blockht'  => '#fffffc',
        'blockbg'  => '#f1e8d6',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'olivegarden' => array(
      'title' => t('Olive Garden'),
      'colors' => array(
        'base'     => '#afc94a',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#61751f',
        'top'      => '#2d3701',
        'bottom'   => '#d2f943',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#b3cc53',
        'blockht'  => '#fffffc',
        'blockbg'  => '#e7efc9',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'forestgreen' => array(
      'title' => t('Forest Green'),
      'colors' => array(
        'base'     => '#9bc068',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#3c7c41',
        'top'      => '#0e3d0b',
        'bottom'   => '#6beb37',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#a0c370',
        'blockht'  => '#fffffc',
        'blockbg'  => '#e1ecd2',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'teal' => array(
      'title' => t('Teal'),
      'colors' => array(
        'base'     => '#83b49f',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#486156',
        'top'      => '#174431',
        'bottom'   => '#52bf90',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#89b8a4',
        'blockht'  => '#fffffc',
        'blockbg'  => '#dae9e2',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'aquamarine' => array(
      'title' => t('Aquamarine'),
      'colors' => array(
        'base'     => '#55c0e2',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#000000',
        'top'      => '#085360',
        'bottom'   => '#007e94',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#5ec3e3',
        'blockht'  => '#fffffc',
        'blockbg'  => '#ccecf6',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'oceanwater' => array(
      'title' => t('Ocean Water'),
      'colors' => array(
        'base'     => '#7bc0ea',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#3561b1',
        'top'      => '#025fb1',
        'bottom'   => '#62c8fd',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#82c3eb',
        'blockht'  => '#fffffc',
        'blockbg'  => '#d8ecf9',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'deepblue' => array(
      'title' => t('Deep Blue'),
      'colors' => array(
        'base'     => '#1c44a9',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#4b5cc3',
        'top'      => '#062984',
        'bottom'   => '#5283ff',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#284ead',
        'blockht'  => '#fffffc',
        'blockbg'  => '#bbc7e5',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'graphite' => array(
      'title' => t('Graphite'),
      'colors' => array(
        'base'     => '#9397d7',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#575dc1',
        'top'      => '#091c3e',
        'bottom'   => '#d0d6f6',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#203254',
        'blockht'  => '#fffffc',
        'blockbg'  => '#dfe0f3',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'violet' => array(
      'title' => t('Violet'),
      'colors' => array(
        'base'     => '#ba90c6',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#935b9f',
        'top'      => '#250c27',
        'bottom'   => '#c271d0',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#be96c9',
        'blockht'  => '#fffffc',
        'blockbg'  => '#eadeee',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'purplehaze' => array(
      'title' => t('Purple Haze'),
      'colors' => array(
        'base'     => '#b0a2f6',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#7958a7',
        'top'      => '#25008f',
        'bottom'   => '#c49eff',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#b4a7f6',
        'blockht'  => '#fffffc',
        'blockbg'  => '#e7e3fC',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'silver' => array(
      'title' => t('Silver'),
      'colors' => array(
        'base'     => '#aaaeb1',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#4d637a',
        'top'      => '#8c909b',
        'bottom'   => '#eeecec',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#aeb2b5',
        'blockht'  => '#fffffc',
        'blockbg'  => '#e6e7e8',
        'borders'  => '#e9e9e9',
        'sticky'   => '#f7f7f7',
      ),
    ),
    'ash' => array(
      'title' => t('Ash'),
      'colors' => array(
        'base'     => '#464849',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#2f416f',
        'top'      => '#2a2b2d',
        'bottom'   => '#5d6779',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#555555',
        'blockh'   => '#4f5152',
        'blockht'  => '#ffffff',
        'blockbg'  => '#c8c8c9',
        'borders'  => '#c8c8c9',
        'sticky'   => '#c8c8c9',
      ),
    ),
    'gothic' => array(
      'title' => t('Gothic'),
      'colors' => array(
        'base'     => '#202020',
        'page'     => '#ffffff',
        'sitename' => '#feffff',
        'slogan'   => '#fefefe',
        'header'   => '#fdfdfd',
        'mmenu'    => '#fffffe',
        'link'     => '#11275f',
        'top'      => '#000000',
        'bottom'   => '#808080',
        'ftop'     => '#181818',
        'fbottom'  => '#343434',
        'text'     => '#000000',
        'blockh'   => '#2b2b2b',
        'blockht'  => '#ffffff',
        'blockbg'  => '#bdbdbd',
        'borders'  => '#bdbdbd',
        'sticky'   => '#bdbdbd',
      ),
    ),
  ),

  // CSS files (excluding @import) to rewrite with new color scheme.
  'css' => array(
    'color/colors.css',
  ),

  // Images to copy over
  'copy' => array(
    'images/bullet-round.png',
    'images/bullet-sm-arrow-right.png',
    'images/bullet-sm-arrow-down.png',
    'images/button.gif',
    'images/button-o.gif',
  ),

  // Coordinates of gradient (x, y, width, height)
  'gradients' => array(
    array(
      'dimension' => array(0,0,800,94),
      'direction' => 'vertical',
      'colors'    => array('top', 'bottom'),
    ),
  ),

  // Color areas to fill (x, y, width, height)
  'fill' => array(
    'base' => array(0,0,800,570),
    'link' => array(240,530,40,40),
  ),

  // Coordinates of all the theme slices (x, y, width, height).
  'slices' => array(
    'images/header.png'         => array(2,0,512,88),
    'images/header-tile.png'    => array(792,0,8,88),
    'images/menu-tile.png'      => array(792,0,8,32),
    'images/bg-footer.png'      => array(792,0,8,88),
    'images/bg-footer-tile.png' => array(792,87,1,1),
    'images/bg-menu.png'        => array(0,88,8,32),
    'images/bg-title.png'       => array(20,130,10,10),
    'images/bg-wall.png'        => array(792,120,8,408),
    'images/bg-bar-lite.png'    => array(0,530,8,40),
    'images/bg-bar.png'         => array(20,530,8,40),
    'images/bg-lbar-lite.png'   => array(270,530,8,40),
    'images/bg-lbar.png'        => array(250,530,8,40),
    'images/sf-hover-tile.png'  => array(0,30,250,1),
  ),

  // Reference color used for blending. Matches the base.png's colors.
  'blend_target' => '#ffffff',

  // Preview files.
  'preview_image' => 'color/color-preview.png',
  'preview_css'   => 'color/preview.css',

  // Base file for image generation
  'base_image' => 'color/base.png',
);