
/**
 * @file
 * Attaches the behaviors for the Nivo Slider module.
 */

(function ($) {
  Drupal.behaviors.nivoSlider = {
    attach: function (context, settings) {
      // Initialize the slider
      $('#slider').nivoSlider({
        'effect': Drupal.settings.nivo_slider.effect, // Specify sets like: 'fold,fade,sliceDown'
        'slices': Drupal.settings.nivo_slider.slices, // For slice animations
        'boxCols': Drupal.settings.nivo_slider.boxCols, // For box animations
        'boxRows': Drupal.settings.nivo_slider.boxRows, // For box animations
        'animSpeed': Drupal.settings.nivo_slider.animSpeed, // Slide transition speed
        'pauseTime': Drupal.settings.nivo_slider.pauseTime, // How long each slide will show
        'startSlide': Drupal.settings.nivo_slider.startSlide, // Set starting Slide (0 index)
        'directionNav': Drupal.settings.nivo_slider.directionNav, // Next & Prev navigation
        'directionNavHide': Drupal.settings.nivo_slider.directionNavHide, // Only show on hover
        'controlNav': Drupal.settings.nivo_slider.controlNav, // 1,2,3... navigation
        'controlNavThumbs': Drupal.settings.nivo_slider.controlNavThumbs, // Use thumbnails for Control Nav
        'pauseOnHover': Drupal.settings.nivo_slider.pauseOnHover, // Stop animation while hovering
        'manualAdvance': Drupal.settings.nivo_slider.manualAdvance, // Force manual transitions
        'prevText': Drupal.settings.nivo_slider.prevText, // Prev directionNav text
        'nextText': Drupal.settings.nivo_slider.nextText, // Next directionNav text
        'randomStart': Drupal.settings.nivo_slider.randomStart, // Start on a random slide
        'beforeChange': Drupal.settings.nivo_slider.beforeChange, // Triggers before a slide transition
        'afterChange': Drupal.settings.nivo_slider.afterChange, // Triggers after a slide transition
        'slideshowEnd': Drupal.settings.nivo_slider.slideshowEnd, // Triggers after all slides have been shown
        'lastSlide': Drupal.settings.nivo_slider.lastSlide, // Triggers when last slide is shown
        'afterLoad': Drupal.settings.nivo_slider.afterLoad // Triggers when slider has loaded
      });
    }
  };
}(jQuery));
