/**
 * @file
 * Linkit tinymce dialog helper.
 */
(function ($) {

// Abort if Drupal.linkit is not defined.
if (typeof Drupal.linkit === 'undefined') {
  return ;
}

Drupal.linkit.registerDialogHelper('tinymce', {
  init : function() {},

  /**
   * Prepare the dialog after init.
   */
  afterInit : function () {
    var editor = Drupal.settings.linkit.currentInstance.editor;
    var element, link;

    // Restore the selection if the browser is IE.
    if (tinymce.isIE) {
      editor.selection.moveToBookmark(editor.windowManager.bookmark);
    }

    // If we have selected a link element, lets populate the fields in the
    // dialog with the values from that link element.
    if (element = editor.dom.getParent(editor.selection.getNode(), 'A')) {
      link = {
        path: editor.dom.getAttrib(element, 'href'),
        attributes: {}
      };

      // Get all attributes that have fields in the modal.
      var additionalAttributes = Drupal.linkit.additionalAttributes();

      // Add attributes to the link object, but only those that are enabled in Linkit.
      tinymce.each(additionalAttributes, function(attribute) {
        var value = editor.dom.getAttrib(element, attribute);
        if (value) {
          link.attributes[attribute] = value;
        }
      });
    }

    // Populate the fields.
    Drupal.linkit.populateFields(link);
  },

  /**
   * Insert the link into the editor.
   *
   * @param {Object} link
   *   The link object.
   */
  insertLink : function(data) {
    var editor = Drupal.settings.linkit.currentInstance.editor,
    element = editor.dom.getParent(editor.selection.getNode(), 'A');

    // Restore the selection if the browser is IE.
    if (tinymce.isIE) {
      editor.selection.moveToBookmark(editor.windowManager.bookmark);
    }

    // Set undo begin point.
    editor.execCommand("mceBeginUndoLevel");
    data.attributes.href = data.path;
    // No link element selected, create a new anchor element.
    if (element == null) {
      // If there is no selection, lets inser a new element.
      if (editor.selection.isCollapsed()) {
        var content = (Drupal.settings.linkit.currentInstance.linkContent) ? Drupal.settings.linkit.currentInstance.linkContent : data.path;
        editor.execCommand('mceInsertContent', false,
          editor.dom.createHTML('a', data.attributes, content));
      } else {
        editor.execCommand("mceInsertLink", false, data.attributes);
      }
    }
    // We are editing an existing link, so just overwrite the attributes.
    else {
      editor.dom.setAttribs(element, data.attributes);
    }

    // Don't move caret if selection was image
    if(element != null) {
      if (element.childNodes.length != 1 || element.firstChild.nodeName != 'IMG') {
        editor.focus();
        editor.selection.select(element);
        editor.selection.collapse(0);
        // Restore the selection if the browser is IE.
        if (tinymce.isIE) {
          editor.selection.moveToBookmark(editor.windowManager.bookmark);
        }
      }
    }
    // Set undo end point.
    editor.execCommand("mceEndUndoLevel");
  }
});

})(jQuery);