<?php
// $Id: views-view-fields.tpl.php,v 1.6 2008/09/24 22:48:21 merlinofchaos Exp $
/**
 * @file views-view-fields.tpl.php
 * Default simple view template to all the fields as a row.
 *
 * - $view: The view in use.
 * - $fields: an array of $field objects. Each one contains:
 *   - $field->content: The output of the field.
 *   - $field->raw: The raw data for the field, if it exists. This is NOT output safe.
 *   - $field->class: The safe class id to use.
 *   - $field->handler: The Views field handler object controlling this field. Do not use
 *     var_export to dump this object, as it can't handle the recursion.
 *   - $field->inline: Whether or not the field should be inline.
 *   - $field->inline_html: either div or span based on the above flag.
 *   - $field->separator: an optional separator that may appear before a field.
 * - $row: The raw result object from the query, with all data it fetched.
 *
 * @ingroup views_templates
 */
?>
<div>
<?php foreach ($fields as $id => $field): ?>
 <span>
<?php
  if ($id == 'fname') {
    $layout_url = base_path() . drupal_get_path('module', 'filedepot');
    $filedepot = filedepot_filedepot();
    // Strip off <span class="field-content">X</span> tags
    $matches = array();
    preg_match('/<span.*?>(.*?)<\/span>/', $field->content, $matches);
    $icon = $filedepot->getFileIcon((count($matches) > 0) ? $matches[1] : "none");
    $extension_icon = "{$layout_url}/css/images/$icon";
    print '<span><img src="' . $extension_icon .'"></span>';
  }
  else {
?>
    <?php if ($field->label): ?>
      <label class="views-label-<?php print $field->class; ?>">
        <?php print $field->label; ?>:
      </label>
    <?php endif; ?>
      <?php
      // $field->element_type is either SPAN or DIV depending upon whether or not
      // the field is a 'block' element type or 'inline' element type.
      ?>
      <<?php print $field->element_type; ?> class="field-content"><?php print $field->content; ?></<?php print $field->element_type; ?>>
</span>

  <?php } ?>

<?php endforeach; ?>
</div>

